package w83b.w83bBeans;



import java.sql.ResultSet;
import java.sql.SQLException;

import w83b.util.jdbc.W83bDataBase;
import w83b.w83bDAO.w83bConstantesBD.W83bDelegacionesBD;
import w83b.w83bDAO.w83bConstantesBD.W83bMunicipiosBD;
import w83b.w83bDAO.w83bConstantesBD.W83bProvinciasBD;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;



/*
 * @author jrgil 
 */
public class W83bDelegacionesBean extends W83bBaseBean implements W83bBaseBeanBD{
	private static final long	serialVersionUID	= 1L;

	private String	codTerritorio = "";
	private String	descTerritorio = "";
	private String	telefono1 = "";
	private String	telefono2 = "";
	private String	fax = "";
	private String	calle = "";
	private String	numero = "";
	private String	piso = "";
	private String	letra = "";
	private String	codPostal = "";
	private String	localidad = "";
	private String	descLocalidad = "";
	private String  registroEntrada = "";
	private String  numModelo = "";
	private String  numModeloSalida = "";
	private String	codServCent = "";
	private String	descDireccionFormato = "";
	
	public String getCodTerritorio() {
		return codTerritorio;
	}

	public void setCodTerritorio(String codTerritorio) {
		this.codTerritorio = codTerritorio;
	}

	public String getTelefono1() {
		return telefono1;
	}

	public void setTelefono1(String telefono1) {
		this.telefono1 = telefono1;
	}

	public String getTelefono2() {
		return telefono2;
	}

	public void setTelefono2(String telefono2) {
		this.telefono2 = telefono2;
	}

	public String getFax() {
		return fax;
	}

	public void setFax(String fax) {
		this.fax = fax;
	}
	public String getCalle() {
		return calle;
	}

	public void setCalle(String calle) {
		this.calle = calle;
	}

	public String getNumero() {
		return numero;
	}

	public void setNumero(String numero) {
		this.numero = numero;
	}

	public String getPiso() {
		return piso;
	}

	public void setPiso(String piso) {
		this.piso = piso;
	}

	public String getLetra() {
		return letra;
	}

	public void setLetra(String letra) {
		this.letra = letra;
	}

	public String getCodPostal() {
		return codPostal;
	}

	public void setCodPostal(String codPostal) {
		this.codPostal = codPostal;
	}

	public String getLocalidad() {
		return localidad;
	}

	public void setLocalidad(String localidad) {
		this.localidad = localidad.toUpperCase();
	}

	public void setRegistroEntrada(String registroEntrada) {
		this.registroEntrada = registroEntrada;
	}

	public String getRegistroEntrada() {
		return registroEntrada;
	}
	public void setDireccion (String dir){
		String[] direccion = dir.split(", ");
		
		this.calle = direccion[0];
		this.numero = direccion[1];
		this.piso = direccion[2];
		if("-".equals(this.piso)){
			this.piso = null;
		}
		this.letra = direccion[3];
		if("-".equals(this.letra)){
			this.letra = null;
		}
		
	}
	
	public String getDireccion (){
		
		StringBuffer direccion = new StringBuffer(W83bClsConstantes.CUARENTA);
		direccion.append(this.calle).append(", ").append(this.numero).append(", ");
		if(this.piso!=null){
			direccion.append(this.piso).append(", ");
		}
		if(this.letra!=null){
			direccion.append(this.letra);
		}
		return direccion.toString();
	}
	
	public void setDescDireccionFormato(String descDireccionFormato) {
		this.descDireccionFormato = descDireccionFormato;
	}


	public String getDescDireccionFormato() {
		return descDireccionFormato;
	}


	public void setNumModelo(String numModelo) {
		this.numModelo = numModelo;
	}


	public String getNumModelo() {
		return numModelo;
	}


	public void setNumModeloSalida(String numModeloSalida) {
		this.numModeloSalida = numModeloSalida;
	}


	public String getNumModeloSalida() {
		return numModeloSalida;
	}


	public void setDescTerritorio(String descTerritorio) {
		this.descTerritorio = descTerritorio.toUpperCase();
	}


	public String getDescTerritorio() {
		return descTerritorio;
	}


	public void setDescLocalidad(String descLocalidad) {
		this.descLocalidad = descLocalidad.toUpperCase();
	}


	public String getDescLocalidad() {
		return descLocalidad;
	}


	public void setCodServCent(String codServCent) {
		this.codServCent = codServCent;
	}


	public String getCodServCent() {
		return codServCent;
	}


	public Object rowToBean(Object o, Object otrosValores) throws SQLException, Q70GestorMensajesException {
		// TODO Auto-generated method stub
		ResultSet rs= (ResultSet)o;//NOPMD
		this.codTerritorio = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.codTerritorio);
		this.descTerritorio = W83bDataBase.getStringFromRS(rs, W83bProvinciasBD.nombreProvincia).toUpperCase();
		this.codServCent = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.codServCent);
		this.telefono1 = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.telefono1);
		this.telefono2 = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.telefono2);
		this.fax = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.fax);
		this.calle = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.calle).toUpperCase();
		this.numero = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.numero);
		this.piso = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.piso);
		this.letra = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.letra);
		this.codPostal = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.codPostal);
		this.localidad = W83bDataBase.getStringFromRS(rs, W83bMunicipiosBD.codMunic);
		this.descLocalidad = W83bDataBase.getStringFromRS(rs, W83bMunicipiosBD.nomMunic_Cast).toUpperCase();
		this.numModelo = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.numModelo);
		this.numModeloSalida = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.numModeloSalida);
		this.registroEntrada = W83bDataBase.getStringFromRS(rs, W83bDelegacionesBD.registroEntrada);
		
		return this;
	}


	
}
